<?php

namespace App\Http\Controllers\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Post;
use App\Http\Requests\Therapists\TherapistPosts\CreateRequest;
use App\Http\Resources\Web\PostsResource;
use Excel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistPostsController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('therapist');
        // $this->middleware('permission:therapist_posts.index');
        // $this->middleware('permission:therapist_posts.create',['only' => ['store']]);
        // $this->middleware('permission:therapist_posts.update',['only' => ['update']]);
        // $this->middleware('permission:therapist_posts.delete',['only' => ['destroy']]);
        // $this->middleware('permission:therapist_posts.export',['only' => ['export']]);
        // $this->middleware('permission:therapist_posts.import',['only' => ['import']])
        // $this->middleware('permission:therapist_posts.update|therapist_posts.is_active',['only' => ['updateStatus']]);
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public function getter($req = null, $export = null)
    {
        $therapist = auth()->user()->therapist;
        if ($req != null) {
            $therapist_posts =  $therapist->therapist_posts()->withAll();
            if ($req->trash && $req->trash == 'with') {
                $therapist_posts =  $therapist_posts->withTrashed();
            }
            if ($req->trash && $req->trash == 'only') {
                $therapist_posts =  $therapist_posts->onlyTrashed();
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_posts = $therapist_posts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {

                $therapist_posts = $therapist_posts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort && $req->sort['field'] != null && $req->sort['type'] != null) {
                $therapist_posts = $therapist_posts->OrderBy($req->sort['field'], $req->sort['type']);
            } else {
                $therapist_posts = $therapist_posts->OrderBy('id', 'desc');
            }
            if ($export != null) { // for export do not paginate
                $therapist_posts = $therapist_posts->get();
                return $therapist_posts;
            }
            $totalTherapistPosts = $therapist_posts->count();
            $therapist_posts = $therapist_posts->paginate($req->perPage);
            $therapist_posts = PostsResource::collection($therapist_posts)->response()->getData(true);

            return $therapist_posts;
        }
        $therapist_posts = PostsResource::collection($therapist->therapist_posts()->withAll()->orderBy('id', 'desc')->paginate(10))->response()->getData(true);
        return $therapist_posts;
    }

    /********* FETCH ALL TherapistPosts ***********/
    public function index()
    {
        $therapist_posts =  $this->getter();
        $response = generateResponse($therapist_posts, count($therapist_posts['data']) > 0 ? true : false, 'TherapistPosts Fetched Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* FILTER TherapistPosts FOR Search ***********/
    public function filter(Request $request)
    {
        $therapist_posts = $this->getter($request);
        $response = generateResponse($therapist_posts, count($therapist_posts['data']) > 0 ? true : false, 'Filter TherapistPosts Successfully', null, 'collection');
        return response()->json($response, 200);
    }

    /********* ADD NEW TherapistPost ***********/
    public function store(CreateRequest $request)
    {
        $therapist = auth()->user()->therapist;
        try {
            DB::beginTransaction();
            $request->merge(['created_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            $data['image'] = uploadCroppedFile($request, 'image', 'therapist_posts');
            $therapist_post = $therapist->therapist_posts()->create($data);
            $therapist_post->slug = Str::slug($therapist_post->name . ' ' . $therapist_post->id, '-');
            $therapist_post->save();
            $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post->id);
            $therapist_post = new PostsResource($therapist_post);
            $therapist_post->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show($therapist_post)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_post->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_post = $therapist->therapist_posts()->withAll()->find($therapist_post);
        if ($therapist_post) {
            $therapist_post = new PostsResource($therapist_post);
            $response = generateResponse($therapist_post, true, 'TherapistPost Fetched Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistPost Not FOund', null, 'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE TherapistPost ***********/
    public function update(CreateRequest $request, Post $therapist_post)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if ($therapist_post->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        try {
            DB::beginTransaction();
            $request->merge(['last_updated_by_user_id' => auth()->user()->id]);
            $data = $request->all();
            if ($request->image) {
                $data['image'] = uploadCroppedFile($request, 'image', 'therapist_posts', $therapist_post->image);
            } else {
                $data['image'] = $therapist_post->image;
            }
            $therapist_post->update($data);
            $therapist_post = $therapist_post->find($therapist_post->id);
            $slug = Str::slug($therapist_post['name'] . ' ' . $therapist_post->id, '-');
            $therapist_post->update(
                [
                    'slug' => $slug
                ]
            );
            $therapist_post->tags()->sync($request->tag_ids);
            DB::commit();
        } catch (\Exception $e) {
            dd($e->getMessage());
            DB::rollBack();
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
        }
        return redirect()->back();
    }

    /********* UPDATE TherapistPost Status***********/
    public function updateStatus(Request $request, Post $therapist_post)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_post->therapist_id != $therapist->id) {
            return redirect()->back()->withErrors([
                'message' => 'Invalid Request',
                'type' => 'error'
            ]);
        }
        $therapist_post->update([
            'is_active' => $therapist_post->is_active == 1 ? 0 : 1
        ]);
        $response = generateResponse(null, true, 'TherapistPost Status Updated Successfully', null, 'object');
        return response()->json($response, 200);
    }


    /********* DELETE TherapistPost ***********/
    public function destroy(Request $request, Post $therapist_post)
    {
        $therapist = auth()->user()->therapist;
        if ($therapist_post->therapist_id != $therapist->id) {
            request()->session()->flash('alert', ['message' => 'Invalid Request', 'type' => 'error']);
            return redirect()->back();
        }
        if ($therapist_post->trashed()) {
            request()->session()->flash('alert', ['message' => 'Already in Trash', 'type' => 'error']);
        } else {
            $therapist_post->delete();
        }
        return redirect()->back();
    }
    /*********Permanently DELETE TherapistPost ***********/
    public function destroyPermanently(Request $request, $therapist_post)
    {
        $therapist = auth()->user()->therapist;
        $therapist_post = $therapist->therapist_posts()->withTrashed()->find($therapist_post);
        if ($therapist_post) {
            if ($therapist_post->therapist_id != $therapist->id) {
                return redirect()->back()->withErrors([
                    'message' => 'Invalid Request',
                    'type' => 'error'
                ]);
            }
            if ($therapist_post->trashed()) {
                $therapist_post->forceDelete();
                $response = generateResponse(null, true, 'TherapistPost Deleted Successfully', null, 'object');
            } else {
                $response = generateResponse(null, false, 'TherapistPost is not in trash to delete permanently', null, 'object');
            }
        } else {
            $response = generateResponse(null, false, 'TherapistPost not found', null, 'object');
        }
        return response()->json($response, 200);
    }
    /********* Restore TherapistPost ***********/
    public function restore(Request $request, $therapist_post)
    {
        $therapist = auth()->user()->therapist;
        $therapist_post = $therapist->therapist_posts()->withTrashed()->find($therapist_post);
        if ($therapist_post->trashed()) {
            $therapist_post->restore();
            $response = generateResponse(null, true, 'TherapistPost Restored Successfully', null, 'object');
        } else {
            $response = generateResponse(null, false, 'TherapistPost is not trashed', null, 'object');
        }
        return response()->json($response, 200);
    }
}
